***DATA CLEANING AND PREPARATION***
*Generating variables*
gen id = _n
order id, first
label var id "Respondent ID"

gen Time_choices = max(Qmodule_Timer1, Qmodule_Timer2, Qmodule_Timer3, Qmodule_Timer4)
label var Time_choices "Time in sec choice tasks"
drop Qmodule_Timer1 Qmodule_Timer2 Qmodule_Timer3 Qmodule_Timer4
rename qtime Time_DCE
label var Time_DCE "Time in sec DCE"

*Re-naming and labeling variables*
rename A1_age Age
label var Age "Age years"

rename Q2_recode Age_group
label var Age_group "Age group"
label define age 1 "<18" 2 "18-29" 3 "30-44" 4 "45-59" 5 ">60"
label values Age_group age

rename A2_gender Gender
label var Gender "Gender"
label define gender 1 "Male" 2 "Female" 3 "Other"
label values Gender gender

rename D3_Education Education
label var Education "Education level"
label define education 1 "None" 2 "Primary" 3 "LBO" 4 "VMBO/MAVO" 5 "HAVO/VWO" 6 "MBO" 7 "HBO" 8 "University" 9 "Other"
label values Education education 

rename Q5_1_coronarisk Covid_risk
label var Covid_risk "Risk new Covid wave"
label define covidrisk 1 "No risk" 2 "Low risk" 3 "Reasonable risk" 4 "High risk" 5 "Very high risk"
label values Covid_ris covidrisk

rename Q5_2_coronabeleid Covid_policy
label var Covid_policy "Importance new Covid measures"
label define covidpolicy 1 "Very unimportant" 2 "Unimportant" 3 "Neutral" 4 "Important" 5 "Very important"
label values Covid_policy covidpolicy

label define statements 1 "Completely disagree" 2 "Disagree" 3 "Neutral" 4 "Agree" 5 "Completely agree"
foreach var of varlist Q25_keuzetakenstatementsr1-Q25_keuzetakenstatementsr15{
	label values Q25_keuzetakenstatementsr* statements
}

rename Q25_keuzetakenstatementsr1 Choices_clear
label var Choices_clear "Choices were clear"

rename Q25_keuzetakenstatementsr2 Information_missing
label var Information_missing "Missed relevant information"

rename Q25_keuzetakenstatementsr3 Choices_easy
label var Choices_easy "Choices were easy"

rename Q25_keuzetakenstatementsr4 Important_subject
label var Important_subject "Important subject for opinion"

rename Q25_keuzetakenstatementsr5 Research_trustworthy
label var Research_trustworthy "Research is trustworthy"

rename Q25_keuzetakenstatementsr6 Choices_steered
label var Choices_steered "Choices felt steered"

rename Q25_keuzetakenstatementsr7 Choices_certainty
label var Choices_certainty "Sure about best choice"

rename Q25_keuzetakenstatementsr8 Method_good
label var Method_good "Good advice method citizen"

rename Q25_keuzetakenstatementsr9 Information_reading
label var Information_reading "Information easy to read"

rename Q25_keuzetakenstatementsr10 Choices_unpleasant
label var Choices_unpleasant "Choices felt unpleasant"

rename Q25_keuzetakenstatementsr11 Familiar_subject
label var Familiar_subject "Familiar subject before participation"

rename Q25_keuzetakenstatementsr12 Choices_interesting
label var Choices_interesting "Choices were interesting"

rename Q25_keuzetakenstatementsr13 Choices_focussing
label var Choices_focussing "Focussed on making choices"

rename Q25_keuzetakenstatementsr14 Choices_attributes
label var Choices_attributes "Choices based on specific attributes"

rename Q25_keuzetakenstatementsr15 Choices_attributes2
label var Choices_attributes2 "Choices based on generic attributes"

rename Q28_Maritalstatus Marital_status
label var Marital_status "Marital status"
label define maritalstatus 1 "Married" 2 "Living together" 3 "Single" 4 "Divorced" 5 "Widow(er)" 6 "Other"
label values Marital_status maritalstatus

rename Q29_children Children
label var Children "Have children"
label define children 1 "No" 2 "Yes"
label values Children children 

rename Q29_1_amountchildren Children_amount
label var Children_amount "Number of children"

rename Q30_workstatus Work_status
label var Work_status "Current work status"
label define workstatus 1 "Working fulltime" 2 "Working parttime" 3 "Retired" 4 "Incapacitated" 5 "Student" 6 "Not working" 7 "Housewife/man"
label values Work_status workstatus

rename Q31_Makingendsmeet Making_ends_meet
label var Making_ends_meet "Household making ends meet"
label define makingendsmeet 1 "Much effort" 2 "Some effort" 3 "Neutral" 4 "Quite easy" 5 "Easy"
label values Making_ends_meet makingendsmeet

rename Q32_horeca Horeca
label var Horeca "Visit restaurants, cafes or bars"
label define horeca 1 "No" 2 "Yes, monthly" 3 "Yes, weekly"
label values Horeca horeca 

rename Q33_sport Sport
label var Sport "Visit fitness center"
label values Sport horeca

rename Q34_thuiswerken Work_from_home
label var Work_from_home "Do you work from home"
label define workfromhome 1 "No" 2 "Yes, a few business days" 3 "Yes, all business days"
label values Work_from_home workfromhome

rename Q35_postest Covid_test
label var Covid_test "Tested positive for Covid"
label define covidtest 1 "No, I was never tested" 2 "No, tested but negative" 3 "Yes"
label values Covid_test covidtest

rename Q36_vaccination Covid_vaccine
label var Covid_vaccine "Vaccinated for Covid"
label define covidvaccine 1 "No" 2 "Yes, once" 3 "Yes, twice" 4 "Yes, three times or more"
label values Covid_vaccine covidvaccine 

rename Q39_financialcontinuity Continue_financial
label var Continue_financial "Financial continuity"
label define continuity 1 "< week" 2 "> week; < month" 3 "> month; < 3months" 4 "> 3months; < 6months" 5 "> 6months; < year" 6 "> year"
label values Continue_financial continuity

rename Q40_mentalcontinuity Continue_mental
label var Continue_mental "Mental continuity"
label values Continue_mental continuity

rename Q41_health Health
label var Health "Rate your current health"

rename Q42_vulnerable Vulnerable_health
label var Vulnerable_health "Health status is vulnerable"
label values Vulnerable_health children 

rename Q45_happiness Happiness
label var Happiness "Rate your current happiness"

rename Q7_1_test1 Test_symptoms
label var Test_symptoms "First test question"
label define testsymptoms 1 "Mental" 2 "Physical" 3 "Both"
label values Test_symptoms testsymptoms

rename Q7_1_recode Test_symptoms_check
label var Test_symptoms_check "Check first test question"
label define testcheck 1 "Right" 2 "Wrong"
label values Test_symptoms_check testcheck

rename Q7_2_test2 Test_duration
label var Test_duration "Second test question"
label define testduration 1 "2 or 3 months" 2 "2, 4 or 6 weeks" 3 "5 or 10 days"
label values Test_duration testduration

rename Q7_2_recode Test_duration_check
label var Test_duration_check "Check second test question"
label values Test_duration_check testcheck

gen Choice17_check = max(Q24_block1_Cal, Q24_block2_Cal, Q24_block3_Cal, Q24_block4_Cal)
label var Choice17_check "Check repeated choice task 17"
drop Q24_block1_Cal Q24_block2_Cal Q24_block3_Cal Q24_block4_Cal

label values Choice17_check testcheck

***EXPLORATORY FACTOR ANALYSIS***
*Exclusion criteria check: exclude those who answered both the repeated choice task and two knowledge questions wrong*
tab Choice17_check
tab Test_symptoms_check
tab Test_duration_check
sum if Test_symptoms_check == 2 & Test_duration_check == 2
sum if Choice17_check == 2 & Test_symptoms_check == 2 & Test_duration_check == 2
//no respondents to exclude

*Descriptive statistics*
sum Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2

tab Choices_clear
tab Information_missing
tab Choices_easy
tab Important_subject
tab Research_trustworthy
tab Choices_steered
tab Choices_certainty
tab Method_good
tab Information_reading
tab Choices_unpleasant
tab Familiar_subject
tab Choices_interesting
tab Choices_focussing
tab Choices_attributes
tab Choices_attributes2

*Assessing the adequacy of the correlation matrix*
pwcorr Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2, list

matrix R = r(C)
matrix D = det(R)
matrix list D

ssc install factortest
factortest Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2

*Extracting the inital factors*
pca Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2
screeplot

search fapara
fapara, pca reps(1000) seed(12345)

ssc install minap
minap Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2

factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2, ipf
screeplot

pca Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2, components(5)
factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes Choices_attributes2, ipf factors(5) altdivisor cit(25)

*Rotating the factors to increase interpretability*
factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes, pcf factors(3) altdivisor 
rotate, promax kaiser blanks(0.4)
estat structure 
estat common
matrix M=J(1,colsof(e(Psi)),1)-e(Psi)
matrix list M

factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes2, pcf factors(3) altdivisor 
rotate, promax kaiser blanks(0.4)
estat structure 
estat common
matrix M=J(1,colsof(e(Psi)),1)-e(Psi)
matrix list M

factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes, ipf factors(3) altdivisor cit(25)
rotate, promax kaiser blanks(0.4)
estat structure
estat common
matrix N=J(1,colsof(e(Psi)),1)-e(Psi)
matrix list N

factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Familiar_subject Choices_interesting Choices_focussing Choices_attributes2, ipf factors(3) altdivisor cit(25)
rotate, promax kaiser blanks(0.4)
estat structure
estat common
matrix N=J(1,colsof(e(Psi)),1)-e(Psi)
matrix list N

*Refining the solution*
factor Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Choices_interesting Choices_focussing Choices_attributes2, pcf factors(3) altdivisor 
rotate, promax kaiser blanks(0.4)
estat structure 
estat common
matrix M=J(1,colsof(e(Psi)),1)-e(Psi)
matrix list M
estat kmo

*Internal consistency & reliability*
alpha Choices_clear Information_missing Choices_easy Important_subject Research_trustworthy Choices_steered Choices_certainty Method_good Information_reading Choices_unpleasant Choices_interesting Choices_focussing Choices_attributes2, asis item reverse(Information_missing Choices_steered Choices_unpleasant)

alpha Choices_clear Important_subject Information_reading Choices_interesting Choices_focussing Choices_attributes2, asis item
alpha Information_missing Research_trustworthy Choices_steered Method_good, asis item reverse(Information_missing Choices_steered)
alpha Choices_easy Choices_certainty Choices_unpleasant, asis item reverse(Choices_unpleasant)

*reverse code negatively worded statements*
gen Information_missingR = (6-Information_missing)
gen Choices_steeredR = (6-Choices_steered)
gen Choices_unpleasantR = (6-Choices_unpleasant)

*Factor scores vs. Factor scales*
factor Choices_clear Information_missingR Choices_easy Important_subject Research_trustworthy Choices_steeredR Choices_certainty Method_good Information_reading Choices_unpleasantR Choices_interesting Choices_focussing Choices_attributes2, pcf factors(3) altdivisor 
rotate, promax kaiser blanks(0.4) 
predict Factorscore1 Factorscore2 Factorscore3
 
gen Factorscale1 = (Choices_clear+Important_subject+Information_reading+Choices_interesting+Choices_focussing+Choices_attributes2) 
gen Factorscale2 = (Information_missingR+Research_trustworthy+Choices_steeredR+Method_good)
gen Factorscale3 = (Choices_easy+Choices_certainty+Choices_unpleasantR)

gen Factorscale1M = (Factorscale1/6)
gen Factorscale2M = (Factorscale2/4)
gen Factorscale3M = (Factorscale3/3)

label var Information_missingR "Missed relevant information reversed"
label var Choices_steeredR "Choices felt steered reversed"
label var Choices_unpleasantR "Choices felt unpleasant reversed"
label var Factorscale1 "Scale for factor 1 sum"
label var Factorscale2 "Scale for factor 2 sum"
label var Factorscale3 "Scale for factor 3 sum"
label var Factorscale1M "Scale for factor 1 mean"
label var Factorscale2M "Scale for factor 2 mean"
label var Factorscale3M "Scale for factor 3 mean"

sum Factorscale1 Factorscale1M Factorscale2 Factorscale2M Factorscale3 Factorscale3M, detail
ssc install univar
univar Factorscale1 Factorscale1M Factorscale2 Factorscale2M Factorscale3 Factorscale3M

gen FS1_dummy = 0
replace FS1_dummy = 1 if Factorscale1M < 3.58
gen FS2_dummy = 0
replace FS2_dummy = 1 if Factorscale2M < 3.00
gen FS3_dummy = 0
replace FS3_dummy = 1 if Factorscale3M < 2.67

label var FS1_dummy "Dummy Factorscale1 < Q1"
label var FS2_dummy "Dummy Factorscale2 < Q1"
label var FS3_dummy "Dummy Factorscale3 < Q1"


foreach var in Choice17_check{
	replace Choice17_check = 0 if Choice17_check == 2
	}
	
foreach var in Test_symptoms_check{
	replace Test_symptoms_check = 0 if Test_symptoms_check == 2
	}	

foreach var in Test_duration_check{
	replace Test_duration_check = 0 if Test_duration_check == 2
	}	
	
label define tests 0 "Wrong" 1 "Right"
label values Choice17_check tests
label values Test_symptoms_check tests	
label values Test_duration_check tests	

tab FS1_dummy
tab FS2_dummy
tab FS3_dummy

*create new educational level variable according to the CBS statistics*
tab Education
gen Education_group = 0
replace Education_group = 1 if Education == 5
replace Education_group = 1 if Education == 6
replace Education_group = 2 if Education == 7
replace Education_group = 2 if Education == 8
tab Education_group
order Education_group, after(Education)
label var Education_group "Low, Middle & High education"
label define Education 0 "Low" 1 "Middle" 2 "High"
label values Education_group Education

*Factors and socio-demographic characteristics*
regress Factorscore1 Age Gender Education_group
regress Factorscore1 Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress Factorscore1 Covid_risk Covid_policy i.Covid_vaccine
regress Factorscore1 Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

regress Factorscore2 Age Gender Education_group
regress Factorscore2 Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress Factorscore2 Covid_risk Covid_policy i.Covid_vaccine
regress Factorscore2 Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

regress Factorscore3 Age Gender Education_group
regress Factorscore3 Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress Factorscore3 Covid_risk Covid_policy i.Covid_vaccine
regress Factorscore3 Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

regress FS1_dummy Age Gender Education_group
regress FS1_dummy Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress FS1_dummy Covid_risk Covid_policy i.Covid_vaccine
regress FS1_dummy Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

regress FS2_dummy Age Gender Education_group
regress FS2_dummy Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress FS2_dummy Covid_risk Covid_policy i.Covid_vaccine
regress FS2_dummy Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

regress FS3_dummy Age Gender Education_group
regress FS3_dummy Choice17_check Test_duration_check Test_symptoms_check Time_DCE 
regress FS3_dummy Covid_risk Covid_policy i.Covid_vaccine
regress FS3_dummy Age Gender Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine

*Puzzling Education relation check*
sum Factorscore3 if Education_group == 0
sum Factorscore3 if Education_group == 1
sum Factorscore3 if Education_group == 2

sum FS3_dummy if Education_group == 0
sum FS3_dummy if Education_group == 1
sum FS3_dummy if Education_group == 2

regress Factorscore3 Age Gender i.Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine
regress FS3_dummy Age Gender i.Education_group Choice17_check Test_duration_check Test_symptoms_check Time_DCE Covid_risk Covid_policy i.Covid_vaccine